﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Tilemaps;
using UnityEngine.UIElements;

public class CityTwoDrawer : LSystemDrawer
{
    public override bool Draw(string sentenceToDraw)
    {
        base.Draw("");

        _SavedParameters = new Stack<DrawParameters>();
        _CurrentGridCellPosition = new Vector3Int(GameManager.Instance.RoadsTilemap.size.x / 2, GameManager.Instance.RoadsTilemap.size.y / 2, Constants.TilemapZPosition);
        _CurrentDirection = new Vector2Int(1, 0);
        _CurrentLength = StartingLength;

        foreach (char character in sentenceToDraw)
        {
            switch (character)
            {
                case '[':
                    _SavedParameters.Push(new DrawParameters(_CurrentGridCellPosition, _CurrentDirection, _CurrentLength));
                    break;

                case ']':
                    if (_SavedParameters.Count > 0)
                    {
                        DrawParameters thisParam = _SavedParameters.Pop();
                        _CurrentGridCellPosition = thisParam.CellPosition;
                        _CurrentDirection = thisParam.Direction;
                        _CurrentLength = thisParam.RoadLength;
                    }
                    break;

                case 'F':
                case 'G':
                    if (_CurrentLength <= 0)
                    {
                        _CurrentLength = LengthResetValue;
                    }

                    for (int i = 0; i < _CurrentLength; i++)
                    {
                        Vector3Int newCellPosition = _CurrentGridCellPosition;
                        newCellPosition += new Vector3Int(_CurrentDirection.x, _CurrentDirection.y, 0);
                        TileBase tile = GameManager.Instance.RoadsTilemap.GetTile(newCellPosition);
                        _CurrentGridCellPosition = newCellPosition;
                        DrawInitialRoad(_CurrentGridCellPosition, _CurrentDirection.x != 0);
                    }

                    _CurrentLength -= LengthDecrement;
                    break;

                case '+':
                    if (_CurrentDirection.x != 0)
                    {
                        if (_CurrentDirection.x == -1)
                        {
                            _CurrentDirection.y = 1;
                        }

                        else
                        {
                            _CurrentDirection.y = -1;
                        }

                        _CurrentDirection.x = 0;
                    }

                    else if (_CurrentDirection.y != 0)
                    {
                        if (_CurrentDirection.y == -1)
                        {
                            _CurrentDirection.x = -1;
                        }

                        else
                        {
                            _CurrentDirection.x = 1;
                        }

                        _CurrentDirection.y = 0;
                    }
                    break;

                case '-':
                    if (_CurrentDirection.x != 0)
                    {
                        if (_CurrentDirection.x == -1)
                        {
                            _CurrentDirection.y = -1;
                        }

                        else
                        {
                            _CurrentDirection.y = 1;
                        }

                        _CurrentDirection.x = 0;
                    }

                    else if (_CurrentDirection.y != 0)
                    {
                        if (_CurrentDirection.y == -1)
                        {
                            _CurrentDirection.x = 1;
                        }

                        else
                        {
                            _CurrentDirection.x = -1;
                        }

                        _CurrentDirection.y = 0;
                    }
                    break;

                default:
                    break;
            }
        }

        FinalizeRoads();
        return true;
    }
}
